/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.loot.modifier;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.LootManager;
import com.blamejared.crafttweaker.api.loot.condition.LootConditions;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandLootItemBlockStatePropertyCondition;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandMatchTool;
import com.blamejared.crafttweaker.natives.loot.modifier.ModifierSpecificExpandBlock;
import com.blamejared.crafttweaker.natives.predicate.ExpandItemPredicate;
import com.blamejared.crafttweaker.natives.predicate.ExpandMinMaxBoundsInts;
import com.blamejared.crafttweaker.natives.predicate.ExpandStatePropertiesPredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/loot/modifier/BlockStateLootModifiers")
@ZenCodeType.Expansion(value="crafttweaker.api.block.BlockState")
@ZenRegister
public final class ModifierSpecificExpandBlockState {
    @ZenCodeType.Method
    public static void addBlockLootModifier(BlockState internal, String name, ILootModifier modifier) {
        ModifierSpecificExpandBlock.addLootModifier(internal.m_60734_(), name, modifier);
    }

    @ZenCodeType.Method
    public static void addTargetedLootModifier(BlockState internal, String name, ILootModifier modifier) {
        StatePropertiesPredicate.Builder properties = ExpandStatePropertiesPredicate.create();
        internal.m_61147_().forEach(it -> properties.m_67700_(it, internal.m_61143_(it).toString()));
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.only((LootItemCondition.Builder)ExpandLootItemBlockStatePropertyCondition.create(internal.m_60734_()).m_81784_(properties)), modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(BlockState internal, String name, IItemStack tool, ILootModifier modifier) {
        ModifierSpecificExpandBlockState.addToolLootModifier(internal, name, tool, false, modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(BlockState internal, String name, IItemStack tool, boolean matchDamage, ILootModifier modifier) {
        ModifierSpecificExpandBlockState.addToolLootModifier(internal, name, tool, matchDamage, false, modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(BlockState internal, String name, IItemStack tool, boolean matchDamage, boolean matchNbt, ILootModifier modifier) {
        CompoundTag tag;
        StatePropertiesPredicate.Builder properties = ExpandStatePropertiesPredicate.create();
        internal.m_61147_().forEach(it -> properties.m_67700_(it, internal.m_61143_(it).toString()));
        ItemPredicate.Builder predicateBuilder = ExpandItemPredicate.create(tool);
        if (matchDamage) {
            predicateBuilder.m_151449_(ExpandMinMaxBoundsInts.exactly(tool.getDamage()));
        }
        if (matchNbt && (tag = tool.getInternal().m_41783_()) != null) {
            predicateBuilder.m_45075_(tag);
        }
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.allOf(new LootItemCondition.Builder[]{ExpandLootItemBlockStatePropertyCondition.create(internal.m_60734_()).m_81784_(properties), ExpandMatchTool.create(predicateBuilder)}), modifier);
    }
}

